package w83b.w83bOperacionesPaso.w83bComunicaciones;

import java.util.HashMap;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import w83b.w83bBeans.W83bComunicacionesBean;
import w83b.w83bBeans.W83bPlantillasBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bUtilidades.W83bUtilidadesComunes;
import w83b.w83bUtilidades.W83bUtilidadesRTF;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bUtilidades;
import w83b.w83bUtilidadesComunes.W83bUtilidadesN38API;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesException;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

public class W83bGenerarRtfAcusesAction extends Q70ActionPasoOP{


	
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		
	}

	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
		ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		
		//String strRutaRtf ="";
		HashMap mapaPar = new HashMap();
		List comunicacion=(List)contexto.get("w83bResultadoBean");
		String idioma = (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);
	    W83bUsuarioXLNetsBean usuario = (W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO);
		String provincia = W83bUtilidadesN38API.elegirProvinciaDelegacion(usuario.getPerfilXLNets());        
		StringBuffer  tituloDelelegacionEu = new StringBuffer();
		StringBuffer  tituloDelelegacionEs = new StringBuffer();
		StringBuffer  tituloDepEu = new StringBuffer();
		StringBuffer  tituloDepEs = new StringBuffer();
		tituloDepEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloImagenInforme_eu",idioma));      
		tituloDepEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloImagenInforme_es",idioma));
		if(W83bClsConstantes.CONSTANTE_ALAVA.equals(provincia)){
		       tituloDelelegacionEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionAlava_eu",idioma));
		       tituloDelelegacionEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionAlava_es",idioma));
		}else if(W83bClsConstantes.CONSTANTE_GIPUZKOA.equals(provincia)){
		       tituloDelelegacionEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionGuipuzcoa_eu",idioma));
		       tituloDelelegacionEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionGuipuzcoa_es",idioma));
		}else if(W83bClsConstantes.CONSTANTE_BIZKAIA.equals(provincia)){
		       tituloDelelegacionEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionBizkaia_eu",idioma));        	
		       tituloDelelegacionEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionBizkaia_es",idioma));        	
		}      
		 //String strRutaRtf = Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLAS_RTF")+"PlantillaAcuses.rtf";
		//se rellenan los datos que se van a repetir continuamente para no tener que rellenar por cada elemento
		mapaPar.put("<<DEPEUS>>",tituloDepEu.toString());
		mapaPar.put("<<DEPCAS>>",tituloDepEs.toString());
		mapaPar.put("<<DELEUS>>",tituloDelelegacionEu.toString());
		mapaPar.put("<<DELCAS>>",tituloDelelegacionEs.toString());
		mapaPar.put("<<DELDIR>>",W83bUtilidadesComunes.obtenerCalledelegacionFormateada(usuario).toString());
		String codigopostal="";
		if(StringUtils.isNotEmpty(usuario.getCodigoPostalDelegacion())){
			codigopostal=usuario.getCodigoPostalDelegacion();
		}
		mapaPar.put("<<DELCP>>",codigopostal);
		
		mapaPar.put("<<finrep>>","");
		mapaPar.put("<<iniciorep>>","");
		HashMap mapaPlantillas = (HashMap)contexto.get("w83bPlantillasMap");
		byte[] plantilla = ((W83bPlantillasBean)mapaPlantillas.get(W83bClsConstantes.ACUSES.toUpperCase())).getFichero();
		
		CharSequence content=W83bUtilidadesRTF.leerTodoFichero(plantilla);
		String contenido=content.toString();
		//calculo de coger el trozo que nos interesa repetir
			
		/*la idea es coger el contenido anterior al trozo a repetir le llamaremos "PREV" 
		/* el trozo a repetri "TROZO"
		* y la parte trasera del contenido "POST"
		* 
		* Nuestro contenido final contentra "PREV" + n veces TROZO + "POST"
		*/
		StringBuffer contenidoBuffer=new StringBuffer(contenido);
			
		int y=contenidoBuffer.indexOf("<<iniciorep>>");
		int z=contenidoBuffer.indexOf("<<finrep>>")+15;
		String parteDelante=contenido.substring(0,y);
		String parteDetras=contenido.substring(z,contenido.length());
		int inicio=parteDelante.lastIndexOf("{");
		int fin=parteDetras.indexOf("}")+1+z;
		String parteDelanteLimpia=contenido.substring(0,inicio);
		String parteAtrasLimpia=contenido.substring(fin,contenido.length());
		String saltos="\r\n\\par \r\n\\par \r\n\\par ";
		int inicioSaltos=contenidoBuffer.lastIndexOf(saltos);
		StringBuffer contenidoBufferCorto=new StringBuffer(contenidoBuffer.toString());
		contenidoBufferCorto.replace(inicioSaltos,inicioSaltos+saltos.length(),"");
		StringBuffer datos=new StringBuffer();
		// se aade la parte delantera del documento.
		datos.append(parteDelanteLimpia);
		StringBuffer elemento=new StringBuffer(W83bClsConstantes.CUARENTA);
		int numElem=1;
		int numnotif=0;
		for(int i=0;i<comunicacion.size()-1;i++)
		{
			W83bComunicacionesBean comunic=(W83bComunicacionesBean)comunicacion.get(i);
			numnotif=numnotif+1;
			if ("preaviso".equals(comunicacion.get(comunicacion.size()-1))){
				mapaPar=crearHoja(mapaPar,comunic,usuario,tituloDepEu,tituloDepEs,tituloDelelegacionEu,tituloDelelegacionEs,idioma,"preaviso",numnotif);
			}else if ("laudo".equals(comunicacion.get(comunicacion.size()-1))){
				if ("1".equals(comunic.getOrderby())){
					mapaPar=crearHoja(mapaPar,comunic,usuario,tituloDepEu,tituloDepEs,tituloDelelegacionEu,tituloDelelegacionEs,idioma,"acta",numnotif);
					if(numElem%3==0)
					{
						
						elemento=W83bUtilidadesRTF.sustituirCadenaCaracteresString(contenidoBufferCorto, mapaPar);
						
					}else{
						elemento=W83bUtilidadesRTF.sustituirCadenaCaracteresString(contenidoBuffer, mapaPar);
					}

					datos.append(elemento);
					numElem++;
					numnotif=numnotif+1;
					mapaPar=crearHoja(mapaPar,comunic,usuario,tituloDepEu,tituloDepEs,tituloDelelegacionEu,tituloDelelegacionEs,idioma,"acta",numnotif);
				}
				else{
					mapaPar=crearHoja(mapaPar,comunic,usuario,tituloDepEu,tituloDepEs,tituloDelelegacionEu,tituloDelelegacionEs,idioma,"acta",numnotif);
				}
			}else if ("impug".equals(comunicacion.get(comunicacion.size()-1))||"faltapre".equals(comunicacion.get(comunicacion.size()-1))||"laudonegativo".equals(comunicacion.get(comunicacion.size()-1))||"requemesa".equals(comunicacion.get(comunicacion.size()-1))||"comempresas".equals(comunicacion.get(comunicacion.size()-1))){
				mapaPar=crearHoja(mapaPar,comunic,usuario,tituloDepEu,tituloDepEs,tituloDelelegacionEu,tituloDelelegacionEs,idioma,"acta",numnotif);
			}
			else if ("comincidencias".equals(comunicacion.get(comunicacion.size()-1))){
				mapaPar=crearHoja(mapaPar,comunic,usuario,tituloDepEu,tituloDepEs,tituloDelelegacionEu,tituloDelelegacionEs,idioma,"incidencia",numnotif);
			}

			// si es el elemento es el 3 multiple de 3 hay que retocar el contenido
			//quitar 3 saltos de linea
			
			if(numElem%3==0)
			{
				
				elemento=W83bUtilidadesRTF.sustituirCadenaCaracteresString(contenidoBufferCorto, mapaPar);
				
			}else{
				elemento=W83bUtilidadesRTF.sustituirCadenaCaracteresString(contenidoBuffer, mapaPar);
			}

			datos.append(elemento);
			numElem++;
		}
				
				
		//para cerrar el contenido del documento metemos la parte trasera.
		datos.append(parteAtrasLimpia);
		
        response.setContentType("application/msword");
        response.setContentLength(datos.toString().getBytes().length);
        if ("preaviso".equals(comunicacion.get(comunicacion.size()-1))){
        	 response.setHeader("Content-disposition","attachment;filename=AcusesPreavisos.rtf");
		}else if ("impug".equals(comunicacion.get(comunicacion.size()-1))){
			 response.setHeader("Content-disposition","attachment;filename=AcusesImpugResueltasPeriodo.rtf");
		}else if ("laudo".equals(comunicacion.get(comunicacion.size()-1))){
			 response.setHeader("Content-disposition","attachment;filename=AcusesLaudosResueltosPeriodo.rtf");
		}else if ("faltapre".equals(comunicacion.get(comunicacion.size()-1))){
			 response.setHeader("Content-disposition","attachment;filename=AcusesFaltaPreaviso.rtf");
		}else if ("laudonegativo".equals(comunicacion.get(comunicacion.size()-1))){
			 response.setHeader("Content-disposition","attachment;filename=AcusesLaudoNegativo.rtf");
		}else if ("requemesa".equals(comunicacion.get(comunicacion.size()-1))){
			 response.setHeader("Content-disposition","attachment;filename=AcusesRequerimientoMesa.rtf");
		}else if ("comempresas".equals(comunicacion.get(comunicacion.size()-1))){
			 response.setHeader("Content-disposition","attachment;filename=AcusesComunicacionEmpresas.rtf");
		}else if ("comincidencias".equals(comunicacion.get(comunicacion.size()-1))){
			 response.setHeader("Content-disposition","attachment;filename=AcusesComunicacionIncidencias.rtf");
		}
       
        response.getOutputStream().write(datos.toString().getBytes());
        response.getOutputStream().flush();

		
		return null;
	}
	
	public HashMap crearHoja(HashMap mapaPar,W83bComunicacionesBean comunic, W83bUsuarioXLNetsBean usuario, StringBuffer tituloDepEu, StringBuffer tituloDepEs, StringBuffer tituloDelelegacionEu, StringBuffer tituloDelelegacionEs, String idioma, String tipo, int numnotif) throws NumberFormatException, Q70GestorMensajesException{//NOPMD
		if ("preaviso".equals(tipo)){
			mapaPar.put("<<NENTR>>",comunic.getNumpreaviso());
		}
		else if ("acta".equals(tipo)){
			mapaPar.put("<<NENTR>>",comunic.getTerrit()+"/"+comunic.getAnoacta()+"/"+W83bUtilidades.rellenarCaracter(comunic.getNacta(), "0", 6, true));
		}
		else if ("incidencia".equals(tipo)){
			mapaPar.put("<<NENTR>>",comunic.getTerrit()+"/"+comunic.getAnoincidencia()+"/"+W83bUtilidades.rellenarCaracter(comunic.getNumincidencia(), "0", 6, true));
		}
		mapaPar.put("<<RAZON>>",comunic.getRazon());
		if (W83bClsConstantes.CONSTANTE_NO_VALIDADA.equals(comunic.getCentroSel())||StringUtils.isEmpty(comunic.getDirorig())){
			mapaPar.put("<<DOMIC>>",W83bUtilidades.convertirAVasioSiNulo(comunic.getDomicilio()));
		}
		else{
			mapaPar.put("<<DOMIC>>",W83bUtilidades.convertirAVasioSiNulo(comunic.getDirorig()));
		}
		String cp="";
		cp=comunic.getCodigopostal();
		if (comunic.getCentroSel()==null||W83bClsConstantes.CONSTANTE_NO_VALIDADA.equals(comunic.getCentroSel())||StringUtils.isEmpty(comunic.getCporig())){
			mapaPar.put("<<CPOST>>",cp);
		}
		else{
			mapaPar.put("<<CPOST>>",comunic.getCporig());
		}
		String munic=W83bUtilidades.convertirAVasioSiNulo(comunic.getMunicipio());
		
		if (!("").equals(cp.trim())&&!("").equals(munic.trim())){
			mapaPar.put("<<LOCAL>>","-"+munic);
		}else{
			mapaPar.put("<<LOCAL>>","-"+munic);
		}
		mapaPar.put("<<PROV>>",comunic.getProvincia());
		
		mapaPar.put("<<NUMNOTIF>>",String.valueOf(numnotif));
		return mapaPar;
	}	
}

